{
 Author:       Craig Ward
 Copyright:    <>

 Date:         17/5/96

 Version:      1.0

 Overview:     Contains procs to deal with reading\writing to control.ini, plus,
               the official Windows screen-saver password encryption routines.
*******************************************************************************}
unit Conini;

interface

uses
 WinTypes, WinProcs, Classes, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, iniFiles, messages, SysUtils,Dialogs;

{prototypes}
procedure mReadIni;
procedure mWriteToIni;
function mStir(mask, txt: char): char;
function mPassF(s: string): string;
function mPassB(s: string): string;
function mEncrypt(s: string): string;

var
 sPasswordText: string;       {password}
 sCollection: string;         {main collection - only relevant if bUseAll false}
 bPasswordOn: boolean;        {password enabled?}
 wChangePic: word;            {change picture intervals}
 bScrollTextOn: boolean;      {scroll text?}
 bWallPaperOn: boolean;       {change wallpaper with screen-saver?}
 bUseAll: boolean;            {select from all collections?}

const
 gintMaxCollName = 25;        {maximum number of characters in a collection's name}


implementation

{***ini************************************************************************}

{write to control.ini}
procedure mWriteToIni;
var
 inf: TIniFile;
begin
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'control.ini');
 try
  inf.WriteBool(application.title,'PWProtected',bPasswordOn);
  inf.WriteBool(application.title,'ScrollText',bScrollTextOn);
  inf.WriteBool(application.title,'WallPaper',bWallPaperOn);
  inf.WriteBool(application.title,'UseAll',bUseAll);
  inf.WriteInteger(application.title,'ChangePic',wChangePic);
  if bPasswordOn then inf.WriteString('ScreenSaver','Password',sPasswordText);
  if not bUseAll then inf.WriteString('ScreenSaver','MainCollection',sCollection);
 finally
  inf.free;
 end;
end;

{read control.ini}
procedure mReadIni;
var
 inf: TIniFile;
begin
 inf := TIniFile.create(ExtractFilePath(paramStr(0))+'control.ini');
 {read from ini}
 try
  bPasswordOn := inf.ReadBool(application.title,'PWProtected',false);
  bScrollTextOn := inf.ReadBool(application.title,'ScrollText',true);
  bUseAll := inf.ReadBool(application.title,'UseAll',true);
  sPasswordText := inf.ReadString('ScreenSaver','Password','');
  bWallPaperOn := inf.ReadBool(application.title,'WallPaper',false);
  wChangePic := inf.ReadInteger(application.title,'ChangePic',10);
  sCollection := inf.ReadString(application.title,'MainCollection','');
 finally
  inf.free;
 end;
end;

{***password encryption********************************************************}

{Note: these are the official Windows screen-saver encryption routines}
{*********************************************************************}

{mask and txt are characters to be merged}
function mStir(mask, txt: char): char;
const
 charExclude = [0..$20,$7F..$90,$93..$FF,$3D,$5B,$5D];
var
 bMix: byte;
begin
 bMix := ord(mask) xor ord(txt);
 if bMix in charExclude then
  result := txt
 else
  result := char(bMix);
end;

{scan (forward) through text}
function mPassF(s: string): string;
var
 i: integer;
 cMask: char;
begin
 cMask := s[0]; {find length}
 for i := 1 to length(s) do
  begin
   s[i] := mStir(cMask,s[i]); {xor with length}
   if i = 1 then
    s[i] := mStir(char($2a),s[i]){a constant for first character}
   else
    begin
     s[i] := mStir(char(i-1),s[i]);{xor with current count}
     s[i] := mStir(s[i-1],s[i]);  {xor with prior character}
    end;
  end;
 result := s;
end;

{scan (backwards) through text}
function mPassB(s: string): string;
var
 i: integer;
 cMask: char;
begin
 cMask := s[0];                               {find length}
 for i := length(s) downto 1 do
  begin
   s[i] := mStir(cMask,s[i]); {xor with length}
   if i = length(s) then
    s[i] := mStir(char($2a),s[i])    {a constant for fisrt character}
   else
    begin
     s[i] := mStir(char(i-1), s[i]);    {xor with current count}
     s[i] := mStir(s[i+1], s[i]);     {xor with later character}
    end;
  end;
 result := s;
end;

{take a string, and encrypt it in standard sreen saver way}
function mEncrypt(s: string): string;
var
 i: integer;
begin
 for i := 1 to length(s) do s[i] := UpCase(s[i]); {all caps.}
 if length(s) > 1 then
  result := mPassB(mPassF(s)) {both passes if more than one char.}
 else
  result := mPassF(s); {one pass if one char}
end;


{}
end.
